﻿//////////////////////////////////////////////
// AsyncWorker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Foward decl ------------------------------

namespace nkGraphics
{
	class System ;
}

namespace nkTasks
{
	class SchedulerTask ;
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// nkTasks
#include <NilkinsTasks/Scheduler/Scheduler.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT AsyncWorker final : public nkCommon::MaybeSingletonClass<AsyncWorker>
	{
		public :
		
			// Work request
			void askForResourceWork (nkTasks::SchedulerTask* work) ;

			// Update
			void finalizeWork () ;

		private :

			// Constructors
			AsyncWorker (bool isSingleton) noexcept ;
			AsyncWorker (System* system) noexcept ;

		private :
		
			// Attributes
			nkMemory::UniquePtr<nkTasks::Scheduler> _resourceScheduler ;

		private :

			friend class nkCommon::MaybeSingletonClass<AsyncWorker> ;
			friend class System ;
	} ;
}